/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.design.canvas.simulation;

import filenet.sim.toolkit.designer.properties.IVWSIMPropertyChangeListener;
import filenet.sim.toolkit.designer.properties.VWSIMPropertyChangeEvent;
import filenet.sim.toolkit.designer.properties.VWSIMPropertyData;
import filenet.sim.toolkit.designer.properties.generaltab.VWSIMGeneralTab;
import filenet.sim.toolkit.designer.properties.images.VWSIMImageLoader;
import filenet.sim.toolkit.designer.properties.resources.VWSIMResource;
import filenet.sim.toolkit.designer.properties.resourcestab.VWSIMResourcesPropertiesTab;
import filenet.sim.toolkit.designer.properties.resourcestab.VWSIMRolesPropertiesTab;
import filenet.sim.toolkit.designer.properties.resourcestab.VWSIMShiftsPropertiesTab;
import filenet.sim.toolkit.designer.properties.workflowstab.VWSIMEmbeddedWorkflowsTab;
import filenet.sim.toolkit.utils.VWSIMHelp;
import filenet.vw.apps.designer.VWDesignerCoreData;
import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.design.canvas.IVWDesignerCanvasPanel;
import filenet.vw.toolkit.design.canvas.simulation.VWScenarioActionMenu;
import filenet.vw.toolkit.design.canvas.simulation.VWScenarioMainToolBar;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import javax.swing.BorderFactory;
import javax.swing.JMenu;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class VWScenarioCanvasPanel
extends JPanel
implements IVWDesignerCanvasPanel,
ChangeListener,
IVWSIMPropertyChangeListener {
    private static final int TAB_GENERAL = 0;
    private static final int TAB_WORKFLOWS = 1;
    private static final int TAB_RESOURCES = 2;
    private static final int TAB_SHIFTS = 3;
    private static final int TAB_ROLES = 4;
    private VWScenarioMainToolBar m_mainToolBar = null;
    private JTabbedPane m_tabbedPane = null;
    private VWSIMGeneralTab m_generalTab = null;
    private VWSIMEmbeddedWorkflowsTab m_workflowsTab = null;
    private VWSIMShiftsPropertiesTab m_shiftsTab = null;
    private VWSIMRolesPropertiesTab m_rolesTab = null;
    private VWSIMResourcesPropertiesTab m_resourcesTab = null;
    private VWSIMPropertyData m_propertyData = null;
    private VWDesignerCoreData m_designerCoreData = null;
    private VWScenarioActionMenu m_scenarioActionMenu = null;

    public VWScenarioCanvasPanel(VWSIMPropertyData propertyData, VWDesignerCoreData designerCoreData) {
        this.m_propertyData = propertyData;
        this.m_designerCoreData = designerCoreData;
        this.m_propertyData.setSystemConfiguration(this.m_designerCoreData.getDataDictionary().getSystemConfiguration());
        String sdfFileContents = null;
        if (this.m_designerCoreData.getSolutionHelper() != null) {
            sdfFileContents = this.m_designerCoreData.getSolutionHelper().getSdfFileContents();
        }
        this.m_propertyData.setSdfFileContents(sdfFileContents);
        this.createControls();
        this.m_propertyData.getPropertyChangeEventNotifier().notifyPropertyChange(this, 101);
        this.m_tabbedPane.addChangeListener(this);
        this.m_propertyData.getPropertyChangeEventNotifier().addPropertyChangeListener(this);
    }

    public VWSIMPropertyData getPropertyData() {
        return this.m_propertyData;
    }

    public void initializeActionMenu(JMenu actionMenu) {
        if (this.m_scenarioActionMenu == null) {
            this.m_scenarioActionMenu = new VWScenarioActionMenu(this);
        }
        this.m_scenarioActionMenu.initializeMenu(actionMenu);
    }

    public void initializeEditMenu(JMenu editMenu) {
        if (editMenu != null) {
            editMenu.removeAll();
        }
    }

    public void releaseReferences() {
        if (this.m_generalTab != null) {
            this.m_generalTab.releaseReferences();
            this.m_generalTab = null;
        }
        if (this.m_workflowsTab != null) {
            this.m_workflowsTab.releaseReferences();
            this.m_workflowsTab = null;
        }
        if (this.m_resourcesTab != null) {
            this.m_resourcesTab.releaseReferences();
            this.m_resourcesTab = null;
        }
        if (this.m_shiftsTab != null) {
            this.m_shiftsTab.releaseReferences();
            this.m_shiftsTab = null;
        }
        if (this.m_rolesTab != null) {
            this.m_rolesTab.releaseReferences();
            this.m_rolesTab = null;
        }
        this.m_tabbedPane.removeChangeListener(this);
        this.m_propertyData.getPropertyChangeEventNotifier().removePropertyChangeListener(this);
    }

    public void stateChanged(ChangeEvent event) {
        if (event.getSource() instanceof JTabbedPane) {
            this.m_propertyData.getPropertyChangeEventNotifier().notifyPropertyChange(this, 103);
        }
    }

    public void propertyDataChanged(VWSIMPropertyChangeEvent event) {
        switch (event.getID()) {
            case 102: {
                if (event.getParam() == null || !event.getParam().equals(this.m_propertyData)) break;
                this.m_designerCoreData.getCoordinationEventNotifier().sendCoordinationEvent(this, 726, this.m_propertyData.getScenarioDefinition());
            }
        }
    }

    protected VWDesignerCoreData getDesignerCoreData() {
        return this.m_designerCoreData;
    }

    protected void showTab(int nTabIndex) {
        if (this.m_tabbedPane != null) {
            this.m_tabbedPane.setSelectedIndex(nTabIndex);
        }
    }

    protected void performHelpAction() {
        if (this.m_tabbedPane == null) {
            return;
        }
        StringBuffer helpString = new StringBuffer(VWSIMHelp.Help_Simulation_Designer + "scenariopropertiesdialog_");
        switch (this.m_tabbedPane.getSelectedIndex()) {
            case 0: {
                helpString.append("general");
                break;
            }
            case 4: {
                helpString.append("jobs");
                break;
            }
            case 3: {
                helpString.append("shifts");
                break;
            }
            case 2: {
                helpString.append("resources");
                break;
            }
            case 1: {
                helpString = new StringBuffer(VWSIMHelp.Help_Simulation_Designer + "workflows");
                break;
            }
            default: {
                return;
            }
        }
        helpString.append(".htm");
        VWSIMHelp.displayPage(helpString.toString());
    }

    public void displayWaitCursor() {
        JRootPane rootPane = this.getRootPane();
        if (rootPane != null) {
            rootPane.setCursor(Cursor.getPredefinedCursor(3));
        }
    }

    public void restoreDefaultCursor() {
        JRootPane rootPane = this.getRootPane();
        if (rootPane != null) {
            rootPane.setCursor(Cursor.getDefaultCursor());
        }
    }

    private void createControls() {
        try {
            this.setLayout(new BorderLayout(6, 6));
            this.m_mainToolBar = new VWScenarioMainToolBar(this);
            this.add((Component)this.m_mainToolBar, "First");
            this.m_tabbedPane = new JTabbedPane(1);
            this.m_generalTab = new VWSIMGeneralTab();
            this.m_generalTab.init(this.m_propertyData);
            JScrollPane scrollPane = new JScrollPane(this.m_generalTab);
            scrollPane.setBorder(BorderFactory.createEmptyBorder());
            this.m_tabbedPane.addTab(VWSIMResource.s_generalTab, VWSIMImageLoader.createImageIcon("scenario.gif"), scrollPane);
            this.m_workflowsTab = new VWSIMEmbeddedWorkflowsTab(this.m_designerCoreData.getProcessMenuHelper().getWorkflowCollectionDefinition());
            this.m_workflowsTab.init(this.m_propertyData);
            this.m_tabbedPane.addTab(VWSIMResource.s_workflowsTab, VWSIMImageLoader.createImageIcon("workflow.gif"), this.m_workflowsTab);
            this.m_resourcesTab = new VWSIMResourcesPropertiesTab();
            this.m_resourcesTab.init(this.m_propertyData);
            this.m_tabbedPane.addTab(VWSIMResource.s_resourcesPropertiesTab, VWSIMImageLoader.createImageIcon("resource16.gif"), this.m_resourcesTab);
            this.m_shiftsTab = new VWSIMShiftsPropertiesTab();
            this.m_shiftsTab.init(this.m_propertyData);
            this.m_tabbedPane.addTab(VWSIMResource.s_shiftsPropertiesTab, VWSIMImageLoader.createImageIcon("shift16.gif"), this.m_shiftsTab);
            this.m_rolesTab = new VWSIMRolesPropertiesTab();
            this.m_rolesTab.init(this.m_propertyData);
            this.m_tabbedPane.addTab(VWSIMResource.s_jobsPropertiesTab, VWSIMImageLoader.createImageIcon("role16.gif"), this.m_rolesTab);
            this.add((Component)this.m_tabbedPane, "Center");
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }
}

